import Vue from 'vue'
import Vuex from 'vuex'
import Meta from 'vue-meta'
import ClientOnly from 'vue-client-only'
import NoSsr from 'vue-no-ssr'
import { createRouter } from './router.js'
import NuxtChild from './components/nuxt-child.js'
import NuxtError from './components/nuxt-error.vue'
import Nuxt from './components/nuxt.js'
import App from './App.js'
import { setContext, getLocation, getRouteData, normalizeError } from './utils'
import { createStore } from './store.js'

/* Plugins */

import nuxt_plugin_plugin_6d35bd82 from 'nuxt_plugin_plugin_6d35bd82' // Source: .\\components\\plugin.js (mode: 'all')
import nuxt_plugin_bootstrapvue_d4c76458 from 'nuxt_plugin_bootstrapvue_d4c76458' // Source: .\\bootstrap-vue.js (mode: 'all')
import nuxt_plugin_plugin_05fcbdb2 from 'nuxt_plugin_plugin_05fcbdb2' // Source: .\\vuetify\\plugin.js (mode: 'all')
import nuxt_plugin_nuxtgooglemaps_576fb1dc from 'nuxt_plugin_nuxtgooglemaps_576fb1dc' // Source: .\\nuxt-google-maps.js (mode: 'all')
import nuxt_plugin_cookieuniversalnuxt_6c399a4d from 'nuxt_plugin_cookieuniversalnuxt_6c399a4d' // Source: .\\cookie-universal-nuxt.js (mode: 'all')
import nuxt_plugin_axios_260be4a5 from 'nuxt_plugin_axios_260be4a5' // Source: .\\axios.js (mode: 'all')
import nuxt_plugin_workbox_5475c481 from 'nuxt_plugin_workbox_5475c481' // Source: .\\workbox.js (mode: 'client')
import nuxt_plugin_metaplugin_904eaffe from 'nuxt_plugin_metaplugin_904eaffe' // Source: .\\pwa\\meta.plugin.js (mode: 'all')
import nuxt_plugin_pluginserver_099983a4 from 'nuxt_plugin_pluginserver_099983a4' // Source: .\\color-mode\\plugin.server.js (mode: 'server')
import nuxt_plugin_pluginclient_b83fdbc8 from 'nuxt_plugin_pluginclient_b83fdbc8' // Source: .\\color-mode\\plugin.client.js (mode: 'client')
import nuxt_plugin_axios_5659d192 from 'nuxt_plugin_axios_5659d192' // Source: ..\\plugins\\axios.js (mode: 'all')
import nuxt_plugin_simplebar_28d69fac from 'nuxt_plugin_simplebar_28d69fac' // Source: ..\\plugins\\simplebar.js (mode: 'all')
import nuxt_plugin_vuegooglemap_75fccaf1 from 'nuxt_plugin_vuegooglemap_75fccaf1' // Source: ..\\plugins\\vue-googlemap.js (mode: 'client')
import nuxt_plugin_plugin_03b7832e from 'nuxt_plugin_plugin_03b7832e' // Source: ..\\plugins\\plugin.js (mode: 'client')
import nuxt_plugin_localStorage_830ec59e from 'nuxt_plugin_localStorage_830ec59e' // Source: ..\\plugins\\localStorage.js (mode: 'client')
import nuxt_plugin_chartist_94bdd556 from 'nuxt_plugin_chartist_94bdd556' // Source: ..\\plugins\\chartist.js (mode: 'all')

// Component: <ClientOnly>
Vue.component(ClientOnly.name, ClientOnly)

// TODO: Remove in Nuxt 3: <NoSsr>
Vue.component(NoSsr.name, {
  ...NoSsr,
  render (h, ctx) {
    if (process.client && !NoSsr._warned) {
      NoSsr._warned = true

      console.warn('<no-ssr> has been deprecated and will be removed in Nuxt 3, please use <client-only> instead')
    }
    return NoSsr.render(h, ctx)
  }
})

// Component: <NuxtChild>
Vue.component(NuxtChild.name, NuxtChild)
Vue.component('NChild', NuxtChild)

// Component NuxtLink is imported in server.js or client.js

// Component: <Nuxt>
Vue.component(Nuxt.name, Nuxt)

Object.defineProperty(Vue.prototype, '$nuxt', {
  get() {
    const globalNuxt = this.$root ? this.$root.$options.$nuxt : null
    if (process.client && !globalNuxt && typeof window !== 'undefined') {
      return window.$nuxt
    }
    return globalNuxt
  },
  configurable: true
})

Vue.use(Meta, {"keyName":"head","attribute":"data-n-head","ssrAttribute":"data-n-head-ssr","tagIDKeyName":"hid"})

const defaultTransition = {"name":"page","mode":"out-in","appear":false,"appearClass":"appear","appearActiveClass":"appear-active","appearToClass":"appear-to"}

const originalRegisterModule = Vuex.Store.prototype.registerModule

function registerModule (path, rawModule, options = {}) {
  const preserveState = process.client && (
    Array.isArray(path)
      ? !!path.reduce((namespacedState, path) => namespacedState && namespacedState[path], this.state)
      : path in this.state
  )
  return originalRegisterModule.call(this, path, rawModule, { preserveState, ...options })
}

async function createApp(ssrContext, config = {}) {
  const store = createStore(ssrContext)
  const router = await createRouter(ssrContext, config, { store })

  // Add this.$router into store actions/mutations
  store.$router = router

  // Fix SSR caveat https://github.com/nuxt/nuxt.js/issues/3757#issuecomment-414689141
  store.registerModule = registerModule

  // Create Root instance

  // here we inject the router and store to all child components,
  // making them available everywhere as `this.$router` and `this.$store`.
  const app = {
    head: {"title":"","description":"","meta":[{"charset":"utf-8"},{"name":"viewport","content":"width=device-width, height=device-height,  initial-scale=1.0, user-scalable=no,user-scalable=0"}],"link":[{"rel":"icon","type":"image\u002Fx-icon","href":"\u002Ffavicon.png"},{"rel":"stylesheet","href":"https:\u002F\u002Ffonts.googleapis.com\u002Fcss?family=Lato:300,400,700,900"},{"rel":"stylesheet","type":"text\u002Fcss","href":"https:\u002F\u002Ffonts.googleapis.com\u002Fcss?family=Roboto:100,300,400,500,700,900&display=swap"},{"rel":"stylesheet","type":"text\u002Fcss","href":"https:\u002F\u002Fcdn.jsdelivr.net\u002Fnpm\u002F@mdi\u002Ffont@latest\u002Fcss\u002Fmaterialdesignicons.min.css"}],"script":[],"style":[]},

    store,
    router,
    nuxt: {
      defaultTransition,
      transitions: [defaultTransition],
      setTransitions (transitions) {
        if (!Array.isArray(transitions)) {
          transitions = [transitions]
        }
        transitions = transitions.map((transition) => {
          if (!transition) {
            transition = defaultTransition
          } else if (typeof transition === 'string') {
            transition = Object.assign({}, defaultTransition, { name: transition })
          } else {
            transition = Object.assign({}, defaultTransition, transition)
          }
          return transition
        })
        this.$options.nuxt.transitions = transitions
        return transitions
      },

      err: null,
      errPageReady: false,
      dateErr: null,
      error (err) {
        err = err || null
        app.context._errored = Boolean(err)
        err = err ? normalizeError(err) : null
        let nuxt = app.nuxt // to work with @vue/composition-api, see https://github.com/nuxt/nuxt.js/issues/6517#issuecomment-573280207
        if (this) {
          nuxt = this.nuxt || this.$options.nuxt
        }
        nuxt.dateErr = Date.now()
        nuxt.err = err
        nuxt.errPageReady = false
        // Used in src/server.js
        if (ssrContext) {
          ssrContext.nuxt.error = err
        }
        return err
      }
    },
    ...App
  }

  // Make app available into store via this.app
  store.app = app

  const next = ssrContext ? ssrContext.next : location => app.router.push(location)
  // Resolve route
  let route
  if (ssrContext) {
    route = router.resolve(ssrContext.url).route
  } else {
    const path = getLocation(router.options.base, router.options.mode)
    route = router.resolve(path).route
  }

  // Set context to app.context
  await setContext(app, {
    store,
    route,
    next,
    error: app.nuxt.error.bind(app),
    payload: ssrContext ? ssrContext.payload : undefined,
    req: ssrContext ? ssrContext.req : undefined,
    res: ssrContext ? ssrContext.res : undefined,
    beforeRenderFns: ssrContext ? ssrContext.beforeRenderFns : undefined,
    beforeSerializeFns: ssrContext ? ssrContext.beforeSerializeFns : undefined,
    ssrContext
  })

  function inject(key, value) {
    if (!key) {
      throw new Error('inject(key, value) has no key provided')
    }
    if (value === undefined) {
      throw new Error(`inject('${key}', value) has no value provided`)
    }

    key = '$' + key
    // Add into app
    app[key] = value
    // Add into context
    if (!app.context[key]) {
      app.context[key] = value
    }

    // Add into store
    store[key] = app[key]

    // Check if plugin not already installed
    const installKey = '__nuxt_' + key + '_installed__'
    if (Vue[installKey]) {
      return
    }
    Vue[installKey] = true
    // Call Vue.use() to install the plugin into vm
    Vue.use(() => {
      if (!Object.prototype.hasOwnProperty.call(Vue.prototype, key)) {
        Object.defineProperty(Vue.prototype, key, {
          get () {
            return this.$root.$options[key]
          }
        })
      }
    })
  }

  // Inject runtime config as $config
  inject('config', config)

  if (process.client) {
    // Replace store state before plugins execution
    if (window.__NUXT__ && window.__NUXT__.state) {
      store.replaceState(window.__NUXT__.state)
    }
  }

  // Add enablePreview(previewData = {}) in context for plugins
  if (process.static && process.client) {
    app.context.enablePreview = function (previewData = {}) {
      app.previewData = Object.assign({}, previewData)
      inject('preview', previewData)
    }
  }
  // Plugin execution

  if (typeof nuxt_plugin_plugin_6d35bd82 === 'function') {
    await nuxt_plugin_plugin_6d35bd82(app.context, inject)
  }

  if (typeof nuxt_plugin_bootstrapvue_d4c76458 === 'function') {
    await nuxt_plugin_bootstrapvue_d4c76458(app.context, inject)
  }

  if (typeof nuxt_plugin_plugin_05fcbdb2 === 'function') {
    await nuxt_plugin_plugin_05fcbdb2(app.context, inject)
  }

  if (typeof nuxt_plugin_nuxtgooglemaps_576fb1dc === 'function') {
    await nuxt_plugin_nuxtgooglemaps_576fb1dc(app.context, inject)
  }

  if (typeof nuxt_plugin_cookieuniversalnuxt_6c399a4d === 'function') {
    await nuxt_plugin_cookieuniversalnuxt_6c399a4d(app.context, inject)
  }

  if (typeof nuxt_plugin_axios_260be4a5 === 'function') {
    await nuxt_plugin_axios_260be4a5(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_workbox_5475c481 === 'function') {
    await nuxt_plugin_workbox_5475c481(app.context, inject)
  }

  if (typeof nuxt_plugin_metaplugin_904eaffe === 'function') {
    await nuxt_plugin_metaplugin_904eaffe(app.context, inject)
  }

  if (process.server && typeof nuxt_plugin_pluginserver_099983a4 === 'function') {
    await nuxt_plugin_pluginserver_099983a4(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_pluginclient_b83fdbc8 === 'function') {
    await nuxt_plugin_pluginclient_b83fdbc8(app.context, inject)
  }

  if (typeof nuxt_plugin_axios_5659d192 === 'function') {
    await nuxt_plugin_axios_5659d192(app.context, inject)
  }

  if (typeof nuxt_plugin_simplebar_28d69fac === 'function') {
    await nuxt_plugin_simplebar_28d69fac(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_vuegooglemap_75fccaf1 === 'function') {
    await nuxt_plugin_vuegooglemap_75fccaf1(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_plugin_03b7832e === 'function') {
    await nuxt_plugin_plugin_03b7832e(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_localStorage_830ec59e === 'function') {
    await nuxt_plugin_localStorage_830ec59e(app.context, inject)
  }

  if (typeof nuxt_plugin_chartist_94bdd556 === 'function') {
    await nuxt_plugin_chartist_94bdd556(app.context, inject)
  }

  // Lock enablePreview in context
  if (process.static && process.client) {
    app.context.enablePreview = function () {
      console.warn('You cannot call enablePreview() outside a plugin.')
    }
  }

  // Wait for async component to be resolved first
  await new Promise((resolve, reject) => {
    // Ignore 404s rather than blindly replacing URL in browser
    if (process.client) {
      const { route } = router.resolve(app.context.route.fullPath)
      if (!route.matched.length) {
        return resolve()
      }
    }
    router.replace(app.context.route.fullPath, resolve, (err) => {
      // https://github.com/vuejs/vue-router/blob/v3.4.3/src/util/errors.js
      if (!err._isRouter) return reject(err)
      if (err.type !== 2 /* NavigationFailureType.redirected */) return resolve()

      // navigated to a different route in router guard
      const unregister = router.afterEach(async (to, from) => {
        if (process.server && ssrContext && ssrContext.url) {
          ssrContext.url = to.fullPath
        }
        app.context.route = await getRouteData(to)
        app.context.params = to.params || {}
        app.context.query = to.query || {}
        unregister()
        resolve()
      })
    })
  })

  return {
    store,
    app,
    router
  }
}

export { createApp, NuxtError }
