import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _d2913794 = () => interopDefault(import('..\\pages\\pardakht.vue' /* webpackChunkName: "pages/pardakht" */))
const _9b38f8fc = () => interopDefault(import('..\\pages\\questions\\index.vue' /* webpackChunkName: "pages/questions/index" */))
const _7f6fb698 = () => interopDefault(import('..\\pages\\website\\index.vue' /* webpackChunkName: "pages/website/index" */))
const _77a27eb8 = () => interopDefault(import('..\\pages\\account\\dashboard.vue' /* webpackChunkName: "pages/account/dashboard" */))
const _1de6b985 = () => interopDefault(import('..\\pages\\account\\data.js' /* webpackChunkName: "pages/account/data" */))
const _30e09fce = () => interopDefault(import('..\\pages\\account\\financial.vue' /* webpackChunkName: "pages/account/financial" */))
const _1e1a620e = () => interopDefault(import('..\\pages\\account\\login.vue' /* webpackChunkName: "pages/account/login" */))
const _638b3f90 = () => interopDefault(import('..\\pages\\account\\mydeal.vue' /* webpackChunkName: "pages/account/mydeal" */))
const _4e4183cc = () => interopDefault(import('..\\pages\\account\\saving.vue' /* webpackChunkName: "pages/account/saving" */))
const _68c7a460 = () => interopDefault(import('..\\pages\\account\\setting.vue' /* webpackChunkName: "pages/account/setting" */))
const _10777f50 = () => interopDefault(import('..\\pages\\website\\components\\banner.vue' /* webpackChunkName: "pages/website/components/banner" */))
const _2c3a77c6 = () => interopDefault(import('..\\pages\\website\\components\\blog.vue' /* webpackChunkName: "pages/website/components/blog" */))
const _7e5c80f9 = () => interopDefault(import('..\\pages\\website\\components\\collection_banner.vue' /* webpackChunkName: "pages/website/components/collection_banner" */))
const _0fd87782 = () => interopDefault(import('..\\pages\\website\\components\\commenquestion.vue' /* webpackChunkName: "pages/website/components/commenquestion" */))
const _babc3382 = () => interopDefault(import('..\\pages\\website\\components\\footer.vue' /* webpackChunkName: "pages/website/components/footer" */))
const _30431f23 = () => interopDefault(import('..\\pages\\website\\components\\footerindex.vue' /* webpackChunkName: "pages/website/components/footerindex" */))
const _2242db84 = () => interopDefault(import('..\\pages\\website\\components\\instagram.vue' /* webpackChunkName: "pages/website/components/instagram" */))
const _b2665b12 = () => interopDefault(import('..\\pages\\website\\components\\news.vue' /* webpackChunkName: "pages/website/components/news" */))
const _24d74288 = () => interopDefault(import('..\\pages\\website\\components\\products.vue' /* webpackChunkName: "pages/website/components/products" */))
const _388e35c9 = () => interopDefault(import('..\\pages\\website\\components\\roles.vue' /* webpackChunkName: "pages/website/components/roles" */))
const _e036d2f6 = () => interopDefault(import('..\\pages\\website\\components\\slider.vue' /* webpackChunkName: "pages/website/components/slider" */))
const _74b23533 = () => interopDefault(import('..\\pages\\website\\components\\steps.vue' /* webpackChunkName: "pages/website/components/steps" */))
const _4b165385 = () => interopDefault(import('..\\pages\\index.vue' /* webpackChunkName: "pages/index" */))
const _495fb23d = () => interopDefault(import('..\\pages\\_slug.vue' /* webpackChunkName: "pages/_slug" */))
const _2563ddd0 = () => interopDefault(import('~/pages/index.vue' /* webpackChunkName: "" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/pardakht",
    component: _d2913794,
    name: "pardakht"
  }, {
    path: "/questions",
    component: _9b38f8fc,
    name: "questions"
  }, {
    path: "/website",
    component: _7f6fb698,
    name: "website"
  }, {
    path: "/account/dashboard",
    component: _77a27eb8,
    name: "account-dashboard"
  }, {
    path: "/account/data",
    component: _1de6b985,
    name: "account-data"
  }, {
    path: "/account/financial",
    component: _30e09fce,
    name: "account-financial"
  }, {
    path: "/account/login",
    component: _1e1a620e,
    name: "account-login"
  }, {
    path: "/account/mydeal",
    component: _638b3f90,
    name: "account-mydeal"
  }, {
    path: "/account/saving",
    component: _4e4183cc,
    name: "account-saving"
  }, {
    path: "/account/setting",
    component: _68c7a460,
    name: "account-setting"
  }, {
    path: "/website/components/banner",
    component: _10777f50,
    name: "website-components-banner"
  }, {
    path: "/website/components/blog",
    component: _2c3a77c6,
    name: "website-components-blog"
  }, {
    path: "/website/components/collection_banner",
    component: _7e5c80f9,
    name: "website-components-collection_banner"
  }, {
    path: "/website/components/commenquestion",
    component: _0fd87782,
    name: "website-components-commenquestion"
  }, {
    path: "/website/components/footer",
    component: _babc3382,
    name: "website-components-footer"
  }, {
    path: "/website/components/footerindex",
    component: _30431f23,
    name: "website-components-footerindex"
  }, {
    path: "/website/components/instagram",
    component: _2242db84,
    name: "website-components-instagram"
  }, {
    path: "/website/components/news",
    component: _b2665b12,
    name: "website-components-news"
  }, {
    path: "/website/components/products",
    component: _24d74288,
    name: "website-components-products"
  }, {
    path: "/website/components/roles",
    component: _388e35c9,
    name: "website-components-roles"
  }, {
    path: "/website/components/slider",
    component: _e036d2f6,
    name: "website-components-slider"
  }, {
    path: "/website/components/steps",
    component: _74b23533,
    name: "website-components-steps"
  }, {
    path: "/",
    component: _4b165385,
    name: "index"
  }, {
    path: "/:slug",
    component: _495fb23d,
    name: "slug"
  }, {
    path: "/",
    component: _2563ddd0
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
